/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.util.List;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.tile.TileEntityHeatGenerator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiHeatGenerator
extends GuiMekanismTile<TileEntityHeatGenerator, MekanismTileContainer<TileEntityHeatGenerator>> {
    public GuiHeatGenerator(MekanismTileContainer<TileEntityHeatGenerator> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget((GuiElement)new GuiEnergyTab((IGuiWrapper)this, () -> List.of(GeneratorsLang.PRODUCING_AMOUNT.translate(new Object[]{EnergyDisplay.of((FloatingLong)((TileEntityHeatGenerator)this.tile).getProductionRate())}), MekanismLang.MAX_OUTPUT.translate(new Object[]{EnergyDisplay.of((FloatingLong)((TileEntityHeatGenerator)this.tile).getMaxOutput())}))));
        this.addRenderableWidget((GuiElement)new GuiFluidGauge(() -> ((TileEntityHeatGenerator)this.tile).lavaTank, () -> ((TileEntityHeatGenerator)this.tile).getFluidTanks(null), GaugeType.WIDE, (IGuiWrapper)this, 55, 18));
        this.addRenderableWidget((GuiElement)new GuiVerticalPowerBar((IGuiWrapper)this, (IEnergyContainer)((TileEntityHeatGenerator)this.tile).getEnergyContainer(), 164, 15));
        this.addRenderableWidget((GuiElement)new GuiHeatTab((IGuiWrapper)this, () -> {
            Component temp = MekanismUtils.getTemperatureDisplay((double)((TileEntityHeatGenerator)this.tile).getTotalTemperature(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true);
            Component transfer = MekanismUtils.getTemperatureDisplay((double)((TileEntityHeatGenerator)this.tile).getLastTransferLoss(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)false);
            Component environment = MekanismUtils.getTemperatureDisplay((double)((TileEntityHeatGenerator)this.tile).getLastEnvironmentLoss(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)false);
            return List.of(MekanismLang.TEMPERATURE.translate(new Object[]{temp}), MekanismLang.TRANSFERRED_RATE.translate(new Object[]{transfer}), MekanismLang.DISSIPATED_RATE.translate(new Object[]{environment}));
        }));
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.drawString(guiGraphics, this.f_169604_, this.f_97730_, this.f_97731_, this.titleTextColor());
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

