/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.datadriven;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import guideme.GuideItemSettings;
import guideme.color.ConstantColor;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public record DataDrivenGuide(GuideItemSettings itemSettings, String defaultLanguage, Map<ResourceLocation, ConstantColor> customColors) {
    private static final Codec<Integer> COLOR_VALUE_CODEC = Codec.STRING.comapFlatMap(value -> {
        if (!value.startsWith("#")) {
            return DataResult.error(() -> "Not a color code: " + value);
        }
        try {
            return DataResult.success((Object)((int)Long.parseLong(value.substring(1), 16)));
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> "Exception parsing color code: " + e.getMessage());
        }
    }, rgba -> String.format(Locale.ROOT, "#%08X", rgba));
    private static final Codec<ConstantColor> CONSTANT_COLOR_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)COLOR_VALUE_CODEC.fieldOf("dark_mode").forGetter(ConstantColor::darkModeColor), (App)COLOR_VALUE_CODEC.fieldOf("light_mode").forGetter(ConstantColor::lightModeColor)).apply((Applicative)builder, ConstantColor::new));
    public static Codec<DataDrivenGuide> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)GuideItemSettings.CODEC.optionalFieldOf("item_settings", (Object)GuideItemSettings.DEFAULT).forGetter(DataDrivenGuide::itemSettings), (App)Codec.STRING.optionalFieldOf("default_language", (Object)"en_us").forGetter(DataDrivenGuide::defaultLanguage), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, CONSTANT_COLOR_CODEC).optionalFieldOf("custom_colors", Map.of()).forGetter(DataDrivenGuide::customColors)).apply((Applicative)builder, DataDrivenGuide::new));

    @Deprecated(forRemoval=true)
    public DataDrivenGuide(GuideItemSettings itemSettings) {
        this(itemSettings, "en_us", Map.of());
    }
}

