/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.compound;

import guideme.internal.shaded.lucene.analysis.CharArraySet;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.compound.CompoundWordTokenFilterBase;
import guideme.internal.shaded.lucene.analysis.compound.hyphenation.Hyphenation;
import guideme.internal.shaded.lucene.analysis.compound.hyphenation.HyphenationTree;
import java.io.IOException;
import java.util.Objects;
import org.xml.sax.InputSource;

public class HyphenationCompoundWordTokenFilter
extends CompoundWordTokenFilterBase {
    private final HyphenationTree hyphenator;
    private final boolean noSubMatches;
    private final boolean noOverlappingMatches;
    private final boolean calcSubMatches;

    public HyphenationCompoundWordTokenFilter(TokenStream input, HyphenationTree hyphenator, CharArraySet dictionary) {
        this(input, hyphenator, dictionary, 5, 2, 15, false, false, false);
    }

    public HyphenationCompoundWordTokenFilter(TokenStream input, HyphenationTree hyphenator, CharArraySet dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        this(input, hyphenator, dictionary, minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch, false, false);
    }

    public HyphenationCompoundWordTokenFilter(TokenStream input, HyphenationTree hyphenator, CharArraySet dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch, boolean noSubMatches, boolean noOverlappingMatches) {
        super(input, dictionary, minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
        this.hyphenator = Objects.requireNonNull(hyphenator, "hyphenator");
        this.noSubMatches = noSubMatches;
        this.noOverlappingMatches = noOverlappingMatches;
        this.calcSubMatches = !onlyLongestMatch && !noSubMatches && !noOverlappingMatches;
    }

    public HyphenationCompoundWordTokenFilter(TokenStream input, HyphenationTree hyphenator, int minWordSize, int minSubwordSize, int maxSubwordSize) {
        this(input, hyphenator, null, minWordSize, minSubwordSize, maxSubwordSize, false);
    }

    public HyphenationCompoundWordTokenFilter(TokenStream input, HyphenationTree hyphenator) {
        this(input, hyphenator, 5, 2, 15);
    }

    public static HyphenationTree getHyphenationTree(String hyphenationFilename) throws IOException {
        return HyphenationCompoundWordTokenFilter.getHyphenationTree(new InputSource(hyphenationFilename));
    }

    public static HyphenationTree getHyphenationTree(InputSource hyphenationSource) throws IOException {
        HyphenationTree tree = new HyphenationTree();
        tree.loadPatterns(hyphenationSource);
        return tree;
    }

    @Override
    protected void decompose() {
        if (this.dictionary != null && !this.calcSubMatches && (this.dictionary.contains(this.termAtt.buffer(), 0, this.termAtt.length()) || this.termAtt.length() > 1 && this.dictionary.contains(this.termAtt.buffer(), 0, this.termAtt.length() - 1))) {
            return;
        }
        Hyphenation hyphens = this.hyphenator.hyphenate(this.termAtt.buffer(), 0, this.termAtt.length(), 1, 1);
        if (hyphens == null) {
            return;
        }
        int maxSubwordSize = Math.min(this.maxSubwordSize, this.termAtt.length() - 1);
        int consumed = -1;
        int[] hyp = hyphens.getHyphenationPoints();
        block0: for (int i = 0; i < hyp.length; ++i) {
            if (this.noOverlappingMatches) {
                i = Math.max(i, consumed);
            }
            int start = hyp[i];
            int until = this.noSubMatches ? Math.max(consumed, i) : i;
            for (int j = hyp.length - 1; j > until; --j) {
                int partLength = hyp[j] - start;
                if (partLength > maxSubwordSize) continue;
                if (partLength < this.minSubwordSize) continue block0;
                if (this.dictionary == null || this.dictionary.contains(this.termAtt.buffer(), start, partLength)) {
                    this.tokens.add(new CompoundWordTokenFilterBase.CompoundToken(start, partLength));
                    consumed = j;
                    if (this.calcSubMatches) continue;
                    continue block0;
                }
                if (!this.dictionary.contains(this.termAtt.buffer(), start, partLength - 1)) continue;
                this.tokens.add(new CompoundWordTokenFilterBase.CompoundToken(start, partLength - 1));
                consumed = j;
                if (!this.calcSubMatches) continue block0;
            }
        }
    }
}

