/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.document.DoublePoint;
import guideme.internal.shaded.lucene.document.Field;
import guideme.internal.shaded.lucene.document.FieldType;
import guideme.internal.shaded.lucene.document.SortedNumericDocValuesField;
import guideme.internal.shaded.lucene.document.StoredValue;
import guideme.internal.shaded.lucene.index.DocValuesType;
import guideme.internal.shaded.lucene.search.IndexOrDocValuesQuery;
import guideme.internal.shaded.lucene.search.PointRangeQuery;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.SortField;
import guideme.internal.shaded.lucene.search.SortedNumericSelector;
import guideme.internal.shaded.lucene.search.SortedNumericSortField;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.NumericUtils;

public final class DoubleField
extends Field {
    private static final FieldType FIELD_TYPE = new FieldType();
    private static final FieldType FIELD_TYPE_STORED;
    private final StoredValue storedValue;

    @Deprecated
    public DoubleField(String name, double value) {
        this(name, value, Field.Store.NO);
    }

    public DoubleField(String name, double value, Field.Store stored) {
        super(name, stored == Field.Store.YES ? FIELD_TYPE_STORED : FIELD_TYPE);
        this.fieldsData = NumericUtils.doubleToSortableLong(value);
        this.storedValue = stored == Field.Store.YES ? new StoredValue(value) : null;
    }

    @Override
    public BytesRef binaryValue() {
        byte[] encodedPoint = new byte[8];
        double value = this.getValueAsDouble();
        DoublePoint.encodeDimension(value, encodedPoint, 0);
        return new BytesRef(encodedPoint);
    }

    private double getValueAsDouble() {
        return NumericUtils.sortableLongToDouble(this.numericValue().longValue());
    }

    @Override
    public StoredValue storedValue() {
        return this.storedValue;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " <" + this.name + ":" + this.getValueAsDouble() + ">";
    }

    @Override
    public void setDoubleValue(double value) {
        super.setLongValue(NumericUtils.doubleToSortableLong(value));
        if (this.storedValue != null) {
            this.storedValue.setDoubleValue(value);
        }
    }

    @Override
    public void setLongValue(long value) {
        throw new IllegalArgumentException("cannot change value type from Double to Long");
    }

    public static Query newExactQuery(String field, double value) {
        return DoubleField.newRangeQuery(field, value, value);
    }

    public static Query newRangeQuery(String field, double lowerValue, double upperValue) {
        PointRangeQuery.checkArgs(field, lowerValue, upperValue);
        return new IndexOrDocValuesQuery(DoublePoint.newRangeQuery(field, lowerValue, upperValue), SortedNumericDocValuesField.newSlowRangeQuery(field, NumericUtils.doubleToSortableLong(lowerValue), NumericUtils.doubleToSortableLong(upperValue)));
    }

    public static Query newSetQuery(String field, double ... values) {
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        long[] points = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            points[i] = NumericUtils.doubleToSortableLong(values[i]);
        }
        return new IndexOrDocValuesQuery(DoublePoint.newSetQuery(field, (double[])values.clone()), SortedNumericDocValuesField.newSlowSetQuery(field, points));
    }

    public static SortField newSortField(String field, boolean reverse, SortedNumericSelector.Type selector) {
        return new SortedNumericSortField(field, SortField.Type.DOUBLE, reverse, selector);
    }

    static {
        FIELD_TYPE.setDimensions(1, 8);
        FIELD_TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        FIELD_TYPE.freeze();
        FIELD_TYPE_STORED = new FieldType(FIELD_TYPE);
        FIELD_TYPE_STORED.setStored(true);
        FIELD_TYPE_STORED.freeze();
    }
}

