/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.document.BinaryRangeFieldRangeQuery;
import guideme.internal.shaded.lucene.document.IntRange;
import guideme.internal.shaded.lucene.document.RangeFieldQuery;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

class IntRangeSlowRangeQuery
extends BinaryRangeFieldRangeQuery {
    private final String field;
    private final int[] min;
    private final int[] max;

    IntRangeSlowRangeQuery(String field, int[] min, int[] max, RangeFieldQuery.QueryType queryType) {
        super(field, IntRangeSlowRangeQuery.encodeRanges(min, max), 4, min.length, queryType);
        this.field = field;
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        IntRangeSlowRangeQuery that = (IntRangeSlowRangeQuery)obj;
        return Objects.equals(this.field, that.field) && Arrays.equals(this.min, that.min) && Arrays.equals(this.max, that.max);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + Arrays.hashCode(this.min);
        h = 31 * h + Arrays.hashCode(this.max);
        return h;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.field.equals(field)) {
            b.append(this.field).append(":");
        }
        return b.append("[").append(Arrays.toString(this.min)).append(" TO ").append(Arrays.toString(this.max)).append("]").toString();
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        return super.rewrite(indexSearcher);
    }

    private static byte[] encodeRanges(int[] min, int[] max) {
        byte[] result = new byte[8 * min.length];
        IntRange.verifyAndEncode(min, max, result);
        return result;
    }
}

