/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.document.Field;
import guideme.internal.shaded.lucene.document.FieldType;
import guideme.internal.shaded.lucene.document.ShapeDocValues;
import guideme.internal.shaded.lucene.document.ShapeField;
import guideme.internal.shaded.lucene.geo.Geometry;
import guideme.internal.shaded.lucene.index.DocValuesType;
import guideme.internal.shaded.lucene.index.IndexableFieldType;
import guideme.internal.shaded.lucene.search.Query;

public abstract class ShapeDocValuesField
extends Field {
    protected final ShapeDocValues shapeDocValues;
    protected static final FieldType FIELD_TYPE = new FieldType();

    ShapeDocValuesField(String name, ShapeDocValues shapeDocValues) {
        super(name, FIELD_TYPE);
        this.shapeDocValues = shapeDocValues;
        this.fieldsData = shapeDocValues.binaryValue();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public IndexableFieldType fieldType() {
        return FIELD_TYPE;
    }

    @Override
    public String stringValue() {
        return null;
    }

    @Override
    public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
        return null;
    }

    public int numberOfTerms() {
        return this.shapeDocValues.numberOfTerms();
    }

    public static Query newGeometryQuery(String field, ShapeField.QueryRelation relation, Object ... geometries) {
        throw new IllegalStateException("geometry queries not yet supported on shape doc values for field [" + field + "]");
    }

    public abstract Geometry getCentroid();

    public abstract Geometry getBoundingBox();

    public ShapeField.DecodedTriangle.TYPE getHighestDimensionType() {
        return this.shapeDocValues.getHighestDimension();
    }

    protected abstract double decodeX(int var1);

    protected abstract double decodeY(int var1);

    static {
        FIELD_TYPE.setDocValuesType(DocValuesType.BINARY);
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.freeze();
    }
}

