/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.BinaryDocValues;
import guideme.internal.shaded.lucene.index.ByteVectorValues;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.FieldInfos;
import guideme.internal.shaded.lucene.index.FloatVectorValues;
import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.LeafMetaData;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.NumericDocValues;
import guideme.internal.shaded.lucene.index.PointValues;
import guideme.internal.shaded.lucene.index.PostingsEnum;
import guideme.internal.shaded.lucene.index.SortedDocValues;
import guideme.internal.shaded.lucene.index.SortedNumericDocValues;
import guideme.internal.shaded.lucene.index.SortedSetDocValues;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.search.KnnCollector;
import guideme.internal.shaded.lucene.search.TopDocs;
import guideme.internal.shaded.lucene.search.TopDocsCollector;
import guideme.internal.shaded.lucene.search.TopKnnCollector;
import guideme.internal.shaded.lucene.util.Bits;
import java.io.IOException;

public abstract class LeafReader
extends IndexReader {
    private final LeafReaderContext readerContext = new LeafReaderContext(this);

    protected LeafReader() {
    }

    @Override
    public final LeafReaderContext getContext() {
        this.ensureOpen();
        return this.readerContext;
    }

    public abstract IndexReader.CacheHelper getCoreCacheHelper();

    @Override
    public final int docFreq(Term term) throws IOException {
        Terms terms = Terms.getTerms(this, term.field());
        TermsEnum termsEnum = terms.iterator();
        if (termsEnum.seekExact(term.bytes())) {
            return termsEnum.docFreq();
        }
        return 0;
    }

    @Override
    public final long totalTermFreq(Term term) throws IOException {
        Terms terms = Terms.getTerms(this, term.field());
        TermsEnum termsEnum = terms.iterator();
        if (termsEnum.seekExact(term.bytes())) {
            return termsEnum.totalTermFreq();
        }
        return 0L;
    }

    @Override
    public final long getSumDocFreq(String field) throws IOException {
        Terms terms = this.terms(field);
        if (terms == null) {
            return 0L;
        }
        return terms.getSumDocFreq();
    }

    @Override
    public final int getDocCount(String field) throws IOException {
        Terms terms = this.terms(field);
        if (terms == null) {
            return 0;
        }
        return terms.getDocCount();
    }

    @Override
    public final long getSumTotalTermFreq(String field) throws IOException {
        Terms terms = this.terms(field);
        if (terms == null) {
            return 0L;
        }
        return terms.getSumTotalTermFreq();
    }

    public abstract Terms terms(String var1) throws IOException;

    public final PostingsEnum postings(Term term, int flags) throws IOException {
        assert (term.field() != null);
        assert (term.bytes() != null);
        Terms terms = Terms.getTerms(this, term.field());
        TermsEnum termsEnum = terms.iterator();
        if (termsEnum.seekExact(term.bytes())) {
            return termsEnum.postings(null, flags);
        }
        return null;
    }

    public final PostingsEnum postings(Term term) throws IOException {
        return this.postings(term, 8);
    }

    public abstract NumericDocValues getNumericDocValues(String var1) throws IOException;

    public abstract BinaryDocValues getBinaryDocValues(String var1) throws IOException;

    public abstract SortedDocValues getSortedDocValues(String var1) throws IOException;

    public abstract SortedNumericDocValues getSortedNumericDocValues(String var1) throws IOException;

    public abstract SortedSetDocValues getSortedSetDocValues(String var1) throws IOException;

    public abstract NumericDocValues getNormValues(String var1) throws IOException;

    public abstract FloatVectorValues getFloatVectorValues(String var1) throws IOException;

    public abstract ByteVectorValues getByteVectorValues(String var1) throws IOException;

    public final TopDocs searchNearestVectors(String field, float[] target, int k, Bits acceptDocs, int visitedLimit) throws IOException {
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getVectorDimension() == 0) {
            return TopDocsCollector.EMPTY_TOPDOCS;
        }
        FloatVectorValues floatVectorValues = this.getFloatVectorValues(fi.name);
        if (floatVectorValues == null) {
            return TopDocsCollector.EMPTY_TOPDOCS;
        }
        if ((k = Math.min(k, floatVectorValues.size())) == 0) {
            return TopDocsCollector.EMPTY_TOPDOCS;
        }
        TopKnnCollector collector = new TopKnnCollector(k, visitedLimit);
        this.searchNearestVectors(field, target, (KnnCollector)collector, acceptDocs);
        return collector.topDocs();
    }

    public final TopDocs searchNearestVectors(String field, byte[] target, int k, Bits acceptDocs, int visitedLimit) throws IOException {
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getVectorDimension() == 0) {
            return TopDocsCollector.EMPTY_TOPDOCS;
        }
        ByteVectorValues byteVectorValues = this.getByteVectorValues(fi.name);
        if (byteVectorValues == null) {
            return TopDocsCollector.EMPTY_TOPDOCS;
        }
        if ((k = Math.min(k, byteVectorValues.size())) == 0) {
            return TopDocsCollector.EMPTY_TOPDOCS;
        }
        TopKnnCollector collector = new TopKnnCollector(k, visitedLimit);
        this.searchNearestVectors(field, target, (KnnCollector)collector, acceptDocs);
        return collector.topDocs();
    }

    public abstract void searchNearestVectors(String var1, float[] var2, KnnCollector var3, Bits var4) throws IOException;

    public abstract void searchNearestVectors(String var1, byte[] var2, KnnCollector var3, Bits var4) throws IOException;

    public abstract FieldInfos getFieldInfos();

    public abstract Bits getLiveDocs();

    public abstract PointValues getPointValues(String var1) throws IOException;

    public abstract void checkIntegrity() throws IOException;

    public abstract LeafMetaData getMetaData();
}

