/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.complexPhrase;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.queries.spans.SpanNearQuery;
import guideme.internal.shaded.lucene.queries.spans.SpanNotQuery;
import guideme.internal.shaded.lucene.queries.spans.SpanOrQuery;
import guideme.internal.shaded.lucene.queries.spans.SpanQuery;
import guideme.internal.shaded.lucene.queries.spans.SpanTermQuery;
import guideme.internal.shaded.lucene.queryparser.classic.ParseException;
import guideme.internal.shaded.lucene.queryparser.classic.QueryParser;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.BooleanQuery;
import guideme.internal.shaded.lucene.search.BoostQuery;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.MatchNoDocsQuery;
import guideme.internal.shaded.lucene.search.MultiTermQuery;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.SynonymQuery;
import guideme.internal.shaded.lucene.search.TermQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ComplexPhraseQueryParser
extends QueryParser {
    private ArrayList<ComplexPhraseQuery> complexPhrases = null;
    private boolean isPass2ResolvingPhrases;
    private boolean inOrder = true;
    private ComplexPhraseQuery currentPhraseQuery = null;

    public void setInOrder(boolean inOrder) {
        this.inOrder = inOrder;
    }

    public ComplexPhraseQueryParser(String f, Analyzer a) {
        super(f, a);
    }

    @Override
    protected Query getFieldQuery(String field, String queryText, int slop) {
        ComplexPhraseQuery cpq = new ComplexPhraseQuery(field, queryText, slop, this.inOrder);
        this.complexPhrases.add(cpq);
        return cpq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query parse(String query) throws ParseException {
        if (this.isPass2ResolvingPhrases) {
            MultiTermQuery.RewriteMethod oldMethod = this.getMultiTermRewriteMethod();
            try {
                this.setMultiTermRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_REWRITE);
                Query query2 = super.parse(query);
                return query2;
            }
            finally {
                this.setMultiTermRewriteMethod(oldMethod);
            }
        }
        this.complexPhrases = new ArrayList();
        Query q = super.parse(query);
        this.isPass2ResolvingPhrases = true;
        try {
            for (ComplexPhraseQuery this.currentPhraseQuery : this.complexPhrases) {
                this.currentPhraseQuery.parsePhraseElements(this);
            }
        }
        finally {
            this.isPass2ResolvingPhrases = false;
        }
        return q;
    }

    @Override
    protected Query newTermQuery(Term term, float boost) {
        if (this.isPass2ResolvingPhrases) {
            try {
                this.checkPhraseClauseIsForSameField(term.field());
            }
            catch (ParseException pe) {
                throw new RuntimeException("Error parsing complex phrase", pe);
            }
        }
        return super.newTermQuery(term, boost);
    }

    private void checkPhraseClauseIsForSameField(String field) throws ParseException {
        if (!field.equals(this.currentPhraseQuery.field)) {
            throw new ParseException("Cannot have clause for field \"" + field + "\" nested in phrase  for field \"" + this.currentPhraseQuery.field + "\"");
        }
    }

    @Override
    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if (this.isPass2ResolvingPhrases) {
            this.checkPhraseClauseIsForSameField(field);
        }
        return super.getWildcardQuery(field, termStr);
    }

    @Override
    protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        if (this.isPass2ResolvingPhrases) {
            this.checkPhraseClauseIsForSameField(field);
        }
        return super.getRangeQuery(field, part1, part2, startInclusive, endInclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Query newRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) {
        MultiTermQuery.RewriteMethod originalRewriteMethod = this.getMultiTermRewriteMethod();
        try {
            if (this.isPass2ResolvingPhrases) {
                this.setMultiTermRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_REWRITE);
            }
            Query query = super.newRangeQuery(field, part1, part2, startInclusive, endInclusive);
            return query;
        }
        finally {
            this.setMultiTermRewriteMethod(originalRewriteMethod);
        }
    }

    @Override
    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        if (this.isPass2ResolvingPhrases) {
            this.checkPhraseClauseIsForSameField(field);
        }
        return super.getFuzzyQuery(field, termStr, minSimilarity);
    }

    static class ComplexPhraseQuery
    extends Query {
        final String field;
        final String phrasedQueryStringContents;
        final int slopFactor;
        private final boolean inOrder;
        private final Query[] contents = new Query[1];

        public ComplexPhraseQuery(String field, String phrasedQueryStringContents, int slopFactor, boolean inOrder) {
            this.field = Objects.requireNonNull(field);
            this.phrasedQueryStringContents = Objects.requireNonNull(phrasedQueryStringContents);
            this.slopFactor = slopFactor;
            this.inOrder = inOrder;
        }

        protected void parsePhraseElements(ComplexPhraseQueryParser qp) throws ParseException {
            String oldDefaultParserField = qp.field;
            try {
                qp.field = this.field;
                this.contents[0] = qp.parse(this.phrasedQueryStringContents);
            }
            finally {
                qp.field = oldDefaultParserField;
            }
        }

        @Override
        public void visit(QueryVisitor visitor) {
            visitor.visitLeaf(this);
        }

        @Override
        public Query rewrite(IndexSearcher indexSearcher) throws IOException {
            Query contents = this.contents[0];
            if (contents instanceof TermQuery || contents instanceof MultiTermQuery || contents instanceof SynonymQuery) {
                return contents;
            }
            int numNegatives = 0;
            if (!(contents instanceof BooleanQuery)) {
                throw new IllegalArgumentException("Unknown query type \"" + contents.getClass().getName() + "\" found in phrase query string \"" + this.phrasedQueryStringContents + "\"");
            }
            BooleanQuery bq = (BooleanQuery)contents;
            SpanQuery[] allSpanClauses = new SpanQuery[bq.clauses().size()];
            int i = 0;
            for (Object clause : bq) {
                Query qc = ((BooleanClause)clause).getQuery();
                qc = indexSearcher.rewrite(qc);
                if (((BooleanClause)clause).getOccur().equals((Object)BooleanClause.Occur.MUST_NOT)) {
                    ++numNegatives;
                }
                while (qc instanceof BoostQuery) {
                    qc = ((BoostQuery)qc).getQuery();
                }
                if (qc instanceof BooleanQuery || qc instanceof SynonymQuery) {
                    ArrayList<SpanQuery> sc = new ArrayList<SpanQuery>();
                    BooleanQuery booleanCaluse = qc instanceof BooleanQuery ? (BooleanQuery)qc : this.convert((SynonymQuery)qc);
                    this.addComplexPhraseClause(sc, booleanCaluse);
                    allSpanClauses[i] = sc.size() > 0 ? sc.get(0) : new SpanTermQuery(new Term(this.field, "Dummy clause because no terms found - must match nothing"));
                } else if (qc instanceof MatchNoDocsQuery) {
                    allSpanClauses[i] = new SpanTermQuery(new Term(this.field, "Dummy clause because no terms found - must match nothing"));
                } else if (qc instanceof TermQuery) {
                    TermQuery tq = (TermQuery)qc;
                    allSpanClauses[i] = new SpanTermQuery(tq.getTerm());
                } else {
                    throw new IllegalArgumentException("Unknown query type \"" + qc.getClass().getName() + "\" found in phrase query string \"" + this.phrasedQueryStringContents + "\"");
                }
                ++i;
            }
            if (numNegatives == 0) {
                return new SpanNearQuery(allSpanClauses, this.slopFactor, this.inOrder);
            }
            ArrayList<SpanQuery> positiveClauses = new ArrayList<SpanQuery>();
            i = 0;
            for (BooleanClause clause : bq) {
                if (!clause.getOccur().equals((Object)BooleanClause.Occur.MUST_NOT)) {
                    positiveClauses.add(allSpanClauses[i]);
                }
                ++i;
            }
            SpanQuery[] includeClauses = positiveClauses.toArray(new SpanQuery[positiveClauses.size()]);
            SpanQuery include = null;
            include = includeClauses.length == 1 ? includeClauses[0] : new SpanNearQuery(includeClauses, this.slopFactor + numNegatives, this.inOrder);
            SpanNearQuery exclude = new SpanNearQuery(allSpanClauses, this.slopFactor, this.inOrder);
            SpanNotQuery snot = new SpanNotQuery(include, exclude);
            return snot;
        }

        private BooleanQuery convert(SynonymQuery qc) {
            BooleanQuery.Builder bqb = new BooleanQuery.Builder();
            for (Term t : qc.getTerms()) {
                bqb.add(new BooleanClause(new TermQuery(t), BooleanClause.Occur.SHOULD));
            }
            return bqb.build();
        }

        private void addComplexPhraseClause(List<SpanQuery> spanClauses, BooleanQuery qc) {
            ArrayList<SpanQuery> ors = new ArrayList<SpanQuery>();
            ArrayList nots = new ArrayList();
            for (BooleanClause clause : qc) {
                Query childQuery = clause.getQuery();
                while (childQuery instanceof BoostQuery) {
                    BoostQuery bq = (BoostQuery)childQuery;
                    childQuery = bq.getQuery();
                }
                ArrayList<SpanQuery> chosenList = ors;
                if (clause.getOccur() == BooleanClause.Occur.MUST_NOT) {
                    chosenList = nots;
                }
                if (childQuery instanceof TermQuery) {
                    TermQuery tq = (TermQuery)childQuery;
                    SpanTermQuery stq = new SpanTermQuery(tq.getTerm());
                    chosenList.add(stq);
                    continue;
                }
                if (childQuery instanceof BooleanQuery) {
                    BooleanQuery cbq = (BooleanQuery)childQuery;
                    this.addComplexPhraseClause(chosenList, cbq);
                    continue;
                }
                if (childQuery instanceof MatchNoDocsQuery) {
                    SpanTermQuery stq = new SpanTermQuery(new Term(this.field, "Dummy clause because no terms found - must match nothing"));
                    chosenList.add(stq);
                    continue;
                }
                throw new IllegalArgumentException("Unknown query type:" + childQuery.getClass().getName());
            }
            if (ors.size() == 0) {
                return;
            }
            SpanOrQuery soq = new SpanOrQuery(ors.toArray(new SpanQuery[ors.size()]));
            if (nots.size() == 0) {
                spanClauses.add(soq);
            } else {
                SpanOrQuery snqs = new SpanOrQuery(nots.toArray(new SpanQuery[nots.size()]));
                SpanNotQuery snq = new SpanNotQuery(soq, snqs);
                spanClauses.add(snq);
            }
        }

        @Override
        public String toString(String field) {
            StringBuilder sb = new StringBuilder();
            if (!this.field.equals(field)) {
                sb.append(this.field).append(":");
            }
            sb.append("\"").append(this.phrasedQueryStringContents).append("\"");
            if (this.slopFactor != 0) {
                sb.append("~").append(this.slopFactor);
            }
            return sb.toString();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = this.classHash();
            result = 31 * result + this.field.hashCode();
            result = 31 * result + this.phrasedQueryStringContents.hashCode();
            result = 31 * result + this.slopFactor;
            result = 31 * result + (this.inOrder ? 1 : 0);
            return result;
        }

        @Override
        public boolean equals(Object other) {
            return this.sameClassAs(other) && this.equalsTo((ComplexPhraseQuery)this.getClass().cast(other));
        }

        private boolean equalsTo(ComplexPhraseQuery other) {
            return this.field.equals(other.field) && this.phrasedQueryStringContents.equals(other.phrasedQueryStringContents) && this.slopFactor == other.slopFactor && this.inOrder == other.inOrder;
        }
    }
}

