/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.highlight;

import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.tokenattributes.OffsetAttribute;
import java.io.IOException;

public final class OffsetLimitTokenFilter
extends TokenFilter {
    private int offsetCount;
    private OffsetAttribute offsetAttrib = this.getAttribute(OffsetAttribute.class);
    private int offsetLimit;

    public OffsetLimitTokenFilter(TokenStream input, int offsetLimit) {
        super(input);
        this.offsetLimit = offsetLimit;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.offsetCount < this.offsetLimit && this.input.incrementToken()) {
            int offsetLength = this.offsetAttrib.endOffset() - this.offsetAttrib.startOffset();
            this.offsetCount += offsetLength;
            return true;
        }
        return false;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.offsetCount = 0;
    }
}

