/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.similarities;

import guideme.internal.shaded.lucene.search.CollectionStatistics;
import guideme.internal.shaded.lucene.search.Explanation;
import guideme.internal.shaded.lucene.search.TermStatistics;
import guideme.internal.shaded.lucene.search.similarities.Similarity;

public class BooleanSimilarity
extends Similarity {
    @Override
    public Similarity.SimScorer scorer(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        return new BooleanWeight(boost);
    }

    private static class BooleanWeight
    extends Similarity.SimScorer {
        final float boost;

        BooleanWeight(float boost) {
            this.boost = boost;
        }

        @Override
        public float score(float freq, long norm) {
            return this.boost;
        }

        @Override
        public Explanation explain(Explanation freq, long norm) {
            Explanation queryBoostExpl = Explanation.match((Number)Float.valueOf(this.boost), "boost, query boost", new Explanation[0]);
            return Explanation.match(queryBoostExpl.getValue(), "score(" + this.getClass().getSimpleName() + "), computed from:", queryBoostExpl);
        }
    }
}

