/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.util;

import org.lwjgl.glfw.GLFW;

public final class Transition {
    private static final double EPSILON = 1.0E-4;
    private static final double MIN_UPDATE_DURATION = 0.005;
    private final double valueMin;
    private final double valueMax;
    private final double fullDuration;
    private final double speed;
    private double fullTransitionTime;
    private final ValueGetter getter;
    private final ValueSetter setter;
    private Ticker ticker = Ticker.SYSTEM;
    private double lastUpdated = Double.NaN;
    private double currentTarget = Double.NaN;

    public Transition(double valueMin, double valueMax, double fullDuration, ValueGetter getter, ValueSetter setter) {
        this.valueMin = valueMin;
        this.valueMax = valueMax;
        if (valueMax < valueMin) {
            throw new IllegalArgumentException("Max cannot be smaller than min.");
        }
        this.getter = getter;
        this.setter = setter;
        this.fullDuration = fullDuration;
        if (this.fullDuration <= 0.0) {
            throw new IllegalArgumentException("Full duration must be a positive number");
        }
        this.speed = (valueMax - valueMin) / fullDuration;
    }

    public void set(double targetValue) {
        this.currentTarget = targetValue;
    }

    public void update() {
        if (Double.isNaN(this.currentTarget)) {
            return;
        }
        double timeNow = this.ticker.currentSeconds();
        double elapsed = timeNow - this.lastUpdated;
        if (Double.isNaN(elapsed)) {
            this.lastUpdated = timeNow;
            return;
        }
        if (elapsed < 0.005) {
            return;
        }
        this.lastUpdated = timeNow;
        double distanceTraveled = this.speed * elapsed;
        double currentValue = this.getter.get();
        if (this.currentTarget > currentValue) {
            if ((currentValue += distanceTraveled) > this.currentTarget) {
                currentValue = this.currentTarget;
            }
        } else if ((currentValue -= distanceTraveled) < this.currentTarget) {
            currentValue = this.currentTarget;
        }
        this.setter.set(currentValue);
    }

    public void setTicker(Ticker ticker) {
        this.ticker = ticker;
    }

    private static boolean equal(double a, double b) {
        return Math.abs(a - b) < 1.0E-4;
    }

    @FunctionalInterface
    public static interface Ticker {
        public static final Ticker SYSTEM = GLFW::glfwGetTime;

        public double currentSeconds();
    }

    @FunctionalInterface
    public static interface ValueGetter {
        public double get();
    }

    @FunctionalInterface
    public static interface ValueSetter {
        public void set(double var1);
    }
}

