/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.block.AEBaseBlock;
import appeng.client.render.effects.ParticleTypes;
import appeng.core.AEConfig;
import appeng.core.AppEngClient;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class QuartzFixtureBlock
extends AEBaseBlock
implements SimpleWaterloggedBlock {
    private static final Map<Direction, VoxelShape> SHAPES = new EnumMap<Direction, VoxelShape>(Direction.class);
    public static final DirectionProperty FACING;
    public static final BooleanProperty ODD;
    public static final BooleanProperty WATERLOGGED;

    public QuartzFixtureBlock() {
        super(QuartzFixtureBlock.fixtureProps().m_60953_(b -> 15));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)ODD, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ODD, WATERLOGGED});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] adirection;
        BlockState state = super.m_5573_(context);
        BlockPos pos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(pos);
        boolean oddPlacement = (pos.m_123341_() + pos.m_123342_() + pos.m_123343_()) % 2 != 0;
        state = (BlockState)((BlockState)state.m_61124_((Property)ODD, (Comparable)Boolean.valueOf(oddPlacement))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        Level levelReader = context.m_43725_();
        for (Direction direction : adirection = context.m_6232_()) {
            BlockState placedState = (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            if (!this.m_7898_(placedState, (LevelReader)levelReader, pos)) continue;
            return placedState;
        }
        return null;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (direction.m_122424_() == state.m_61143_((Property)FACING) && !state.m_60710_((LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return SHAPES.get(facing);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource r) {
        if (!AEConfig.instance().isEnableEffects()) {
            return;
        }
        if ((double)r.m_188501_() < 0.98) {
            return;
        }
        BlockOrientation orientation = this.getOrientation(state);
        Direction top = orientation.getSide(RelativeSide.TOP);
        double xOff = -0.3 * (double)top.m_122429_();
        double yOff = -0.3 * (double)top.m_122430_();
        double zOff = -0.3 * (double)top.m_122431_();
        for (int bolts = 0; bolts < 3; ++bolts) {
            if (!AppEngClient.instance().shouldAddParticles(r)) continue;
            level.m_7106_((ParticleOptions)ParticleTypes.LIGHTNING, xOff + 0.5 + (double)pos.m_123341_(), yOff + 0.5 + (double)pos.m_123342_(), zOff + 0.5 + (double)pos.m_123343_(), 0.0, 0.0, 0.0);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = pos.m_121945_(facing.m_122424_());
        return QuartzFixtureBlock.m_49863_((LevelReader)level, (BlockPos)blockPos, (Direction)facing);
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    static {
        for (Direction facing : Direction.values()) {
            double xOff = -0.3 * (double)facing.m_122429_();
            double yOff = -0.3 * (double)facing.m_122430_();
            double zOff = -0.3 * (double)facing.m_122431_();
            VoxelShape shape = Shapes.m_83064_((AABB)new AABB(xOff + 0.3, yOff + 0.3, zOff + 0.3, xOff + 0.7, yOff + 0.7, zOff + 0.7));
            SHAPES.put(facing, shape);
        }
        FACING = BlockStateProperties.f_61372_;
        ODD = BooleanProperty.m_61465_((String)"odd");
        WATERLOGGED = BlockStateProperties.f_61362_;
    }
}

