/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.networktool;

import appeng.api.stacks.AEItemKey;
import appeng.menu.me.networktool.MachineGroupKey;
import java.util.Comparator;
import net.minecraft.network.FriendlyByteBuf;

public class MachineGroup {
    public static final Comparator<MachineGroup> COMPARATOR = Comparator.comparing(MachineGroup::isMissingChannel).thenComparingInt(MachineGroup::getCount).reversed();
    private final MachineGroupKey key;
    private double idlePowerUsage;
    private double powerGenerationCapacity;
    private int count;

    MachineGroup(MachineGroupKey key) {
        this.key = key;
    }

    static MachineGroup read(FriendlyByteBuf data) {
        MachineGroup entry = new MachineGroup(MachineGroupKey.fromPacket(data));
        entry.idlePowerUsage = data.readDouble();
        entry.powerGenerationCapacity = data.readDouble();
        entry.count = data.m_130242_();
        return entry;
    }

    void write(FriendlyByteBuf data) {
        this.key.write(data);
        data.writeDouble(this.idlePowerUsage);
        data.writeDouble(this.powerGenerationCapacity);
        data.m_130130_(this.count);
    }

    public AEItemKey getDisplay() {
        return this.key.display();
    }

    public boolean isMissingChannel() {
        return this.key.missingChannel();
    }

    public double getIdlePowerUsage() {
        return this.idlePowerUsage;
    }

    void setIdlePowerUsage(double idlePowerUsage) {
        this.idlePowerUsage = idlePowerUsage;
    }

    public double getPowerGenerationCapacity() {
        return this.powerGenerationCapacity;
    }

    public void setPowerGenerationCapacity(double powerGenerationCapacity) {
        this.powerGenerationCapacity = powerGenerationCapacity;
    }

    public int getCount() {
        return this.count;
    }

    void setCount(int count) {
        this.count = count;
    }
}

