/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.gas;

import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.providers.IGasProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class GasStack
extends ChemicalStack<Gas> {
    public static final GasStack EMPTY = new GasStack(MekanismAPI.EMPTY_GAS, 0L);

    public GasStack(IGasProvider gasProvider, long amount) {
        super((Gas)gasProvider.getChemical(), amount);
    }

    public GasStack(GasStack stack, long amount) {
        this((IGasProvider)stack.getType(), amount);
    }

    @Override
    protected IForgeRegistry<Gas> getRegistry() {
        return MekanismAPI.gasRegistry();
    }

    @Override
    protected Gas getEmptyChemical() {
        return MekanismAPI.EMPTY_GAS;
    }

    public static GasStack readFromNBT(@Nullable CompoundTag nbtTags) {
        if (nbtTags == null || nbtTags.m_128456_()) {
            return EMPTY;
        }
        Gas type = Gas.readFromNBT(nbtTags);
        if (type.isEmptyType()) {
            return EMPTY;
        }
        long amount = nbtTags.m_128454_("amount");
        if (amount <= 0L) {
            return EMPTY;
        }
        return new GasStack(type, amount);
    }

    public static GasStack readFromPacket(FriendlyByteBuf buf) {
        Gas gas = (Gas)buf.readRegistryIdSafe(Gas.class);
        if (gas.isEmptyType()) {
            return EMPTY;
        }
        return new GasStack(gas, buf.m_130258_());
    }

    public GasStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new GasStack(this, this.getAmount());
    }
}

