/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.creator;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.providers.IFluidProvider;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.creator.IIngredientCreator;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

@NothingNullByDefault
public interface IFluidStackIngredientCreator
extends IIngredientCreator<Fluid, FluidStack, FluidStackIngredient> {
    @Override
    default public FluidStackIngredient from(IFluidProvider provider, int amount) {
        Objects.requireNonNull(provider, "FluidStackIngredients cannot be created from a null fluid provider.");
        return (FluidStackIngredient)this.from(provider.getFluidStack(amount));
    }

    @Override
    default public FluidStackIngredient from(Fluid instance, int amount) {
        return (FluidStackIngredient)this.from(new FluidStack(instance, amount));
    }
}

