/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.item;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Optional;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.client.render.item.ChemicalFluidBarDecorator;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.GenericTankSpec;
import mekanism.common.capabilities.chemical.item.ChemicalTankSpec;
import mekanism.common.capabilities.fluid.item.RateLimitMultiTankFluidHandler;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.util.FluidUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.IItemDecorator;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class MekaSuitBarDecorator
implements IItemDecorator {
    public static final MekaSuitBarDecorator INSTANCE = new MekaSuitBarDecorator();

    private MekaSuitBarDecorator() {
    }

    public boolean render(GuiGraphics guiGraphics, Font font, ItemStack stack, int xOffset, int yOffset) {
        IFluidHandlerItem fluidHandler;
        int tank;
        Optional capabilityInstance;
        List<RateLimitMultiTankFluidHandler.FluidTankSpec> fluidTankSpecs;
        Item item;
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ItemMekaSuitArmor)) {
            return false;
        }
        ItemMekaSuitArmor armor = (ItemMekaSuitArmor)item;
        if (this.tryRender(guiGraphics, stack, Capabilities.GAS_HANDLER, xOffset, yOffset += 12, armor.getGasTankSpecs())) {
            --yOffset;
        }
        if (!(fluidTankSpecs = armor.getFluidTankSpecs()).isEmpty() && (capabilityInstance = FluidUtil.getFluidHandler((ItemStack)stack).resolve()).isPresent() && (tank = MekaSuitBarDecorator.getDisplayTank(fluidTankSpecs, stack, (fluidHandler = (IFluidHandlerItem)capabilityInstance.get()).getTanks())) != -1) {
            FluidStack fluidInTank = fluidHandler.getFluidInTank(tank);
            ChemicalFluidBarDecorator.renderBar(guiGraphics, xOffset, yOffset, fluidInTank.getAmount(), fluidHandler.getTankCapacity(tank), FluidUtils.getRGBDurabilityForDisplay(stack).orElse(-1));
        }
        return true;
    }

    private <CHEMICAL extends Chemical<CHEMICAL>> boolean tryRender(GuiGraphics guiGraphics, ItemStack stack, Capability<? extends IChemicalHandler<CHEMICAL, ?>> capability, int xOffset, int yOffset, List<ChemicalTankSpec<CHEMICAL>> chemicalTankSpecs) {
        IChemicalHandler chemicalHandler;
        int tank;
        Optional capabilityInstance;
        if (!chemicalTankSpecs.isEmpty() && chemicalTankSpecs.stream().anyMatch(spec -> spec.supportsStack(stack)) && (capabilityInstance = stack.getCapability(capability).resolve()).isPresent() && (tank = MekaSuitBarDecorator.getDisplayTank(chemicalTankSpecs, stack, (chemicalHandler = (IChemicalHandler)capabilityInstance.get()).getTanks())) != -1) {
            Object chemicalInTank = chemicalHandler.getChemicalInTank(tank);
            ChemicalFluidBarDecorator.renderBar(guiGraphics, xOffset, yOffset, ((ChemicalStack)chemicalInTank).getAmount(), chemicalHandler.getTankCapacity(tank), ((ChemicalStack)chemicalInTank).getChemicalColorRepresentation());
            return true;
        }
        return false;
    }

    private static <TYPE> int getDisplayTank(List<? extends GenericTankSpec<TYPE>> tankSpecs, ItemStack stack, int tanks) {
        if (tanks == 0) {
            return -1;
        }
        if (tanks > 1 && tanks == tankSpecs.size() && Minecraft.m_91087_().f_91073_ != null) {
            IntArrayList tankIndices = new IntArrayList(tanks);
            for (int i = 0; i < tanks; ++i) {
                if (!tankSpecs.get(i).supportsStack(stack)) continue;
                tankIndices.add(i);
            }
            if (tankIndices.isEmpty()) {
                return -1;
            }
            if (tankIndices.size() == 1) {
                return tankIndices.getInt(0);
            }
            return tankIndices.getInt((int)(Minecraft.m_91087_().f_91073_.m_46467_() / 20L) % tankIndices.size());
        }
        for (int i = 0; i < tanks && i < tankSpecs.size(); ++i) {
            if (!tankSpecs.get(i).supportsStack(stack)) continue;
            return i;
        }
        return -1;
    }
}

