/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedResolvableConfigValue;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class CachedMapConfigValue<KEY, VALUE>
extends CachedResolvableConfigValue<Map<KEY, VALUE>, List<? extends String>> {
    protected CachedMapConfigValue(IMekanismConfig config, ForgeConfigSpec.ConfigValue<List<? extends String>> internal) {
        super(config, internal);
    }

    protected abstract void resolve(String var1, Map<KEY, VALUE> var2);

    protected abstract void encode(KEY var1, VALUE var2, Consumer<String> var3);

    @Override
    protected final Map<KEY, VALUE> resolve(List<? extends String> encoded) {
        HashMap resolved = new HashMap(encoded.size());
        for (String string : encoded) {
            this.resolve(string, resolved);
        }
        return resolved;
    }

    @Override
    protected final List<? extends String> encode(Map<KEY, VALUE> values) {
        return CachedMapConfigValue.encodeStatic(values, this::encode);
    }

    protected static <KEY, VALUE> List<? extends String> encodeStatic(Map<KEY, VALUE> values, ValueEncoder<KEY, VALUE> encoder) {
        ArrayList encoded = new ArrayList(values.size());
        for (Map.Entry<KEY, VALUE> entry : values.entrySet()) {
            encoder.encode(entry.getKey(), entry.getValue(), encoded::add);
        }
        Collections.sort(encoded);
        return encoded;
    }

    protected static interface ValueEncoder<KEY, VALUE> {
        public void encode(KEY var1, VALUE var2, Consumer<String> var3);
    }
}

