/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import mekanism.api.text.EnumColor;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.oredictionificator.OredictionificatorFilter;
import mekanism.common.content.oredictionificator.OredictionificatorItemFilter;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.content.qio.filter.QIOItemStackFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.content.transporter.SorterItemStackFilter;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import mekanism.common.util.text.InputValidator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecialConverters {
    @Nullable
    public static <ENUM extends Enum<?>> ENUM sanitizeStringToEnum(Class<? extends ENUM> expectedType, String argument) {
        if (!argument.isEmpty()) {
            Enum[] enumConstants;
            for (Enum enumConstant : enumConstants = (Enum[])expectedType.getEnumConstants()) {
                if (!argument.equalsIgnoreCase(enumConstant.name())) continue;
                return (ENUM)enumConstant;
            }
        }
        return null;
    }

    private static ItemStack tryCreateFilterItem(@Nullable String rawName, @Nullable String rawNBT) throws ComputerException {
        Item item = SpecialConverters.tryCreateItem(rawName);
        if (item == Items.f_41852_) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        if (rawNBT != null) {
            try {
                stack.m_41751_(NbtUtils.m_178024_((String)rawNBT));
            }
            catch (CommandSyntaxException ex) {
                throw new ComputerException("Invalid SNBT: " + ex.getMessage());
            }
        }
        return stack;
    }

    private static Item tryCreateItem(@Nullable Object rawName) {
        Item item;
        String name;
        ResourceLocation itemName;
        if (rawName instanceof String && (itemName = ResourceLocation.m_135820_((String)(name = (String)rawName))) != null && (item = (Item)ForgeRegistries.ITEMS.getValue(itemName)) != null) {
            return item;
        }
        return Items.f_41852_;
    }

    @Nullable
    private static String tryGetFilterTag(@Nullable Object rawTag) {
        String tag;
        if (rawTag instanceof String && !(tag = (String)rawTag).isEmpty() && InputValidator.test(tag = tag.toLowerCase(Locale.ROOT), InputValidator.RESOURCE_LOCATION.or(InputValidator.WILDCARD_CHARS))) {
            return tag;
        }
        return null;
    }

    @Nullable
    private static String tryGetFilterModId(@Nullable Object rawModId) {
        String modId;
        if (rawModId instanceof String && !(modId = (String)rawModId).isEmpty() && InputValidator.test(modId = modId.toLowerCase(Locale.ROOT), InputValidator.RL_NAMESPACE.or(InputValidator.WILDCARD_CHARS))) {
            return modId;
        }
        return null;
    }

    private static boolean getBooleanFromRaw(@Nullable Object raw) {
        boolean bl;
        if (raw instanceof Boolean) {
            Boolean bool = (Boolean)raw;
            bl = bool;
        } else {
            bl = false;
        }
        return bl;
    }

    static int getIntFromRaw(@Nullable Object raw) {
        int n;
        if (raw instanceof Number) {
            Number number = (Number)raw;
            n = number.intValue();
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public static <FILTER extends IFilter<FILTER>> FILTER convertMapToFilter(@NotNull Class<FILTER> expectedType, @NotNull Map<?, ?> map) throws ComputerException {
        Object type = map.get("type");
        if (!(type instanceof String)) {
            throw new ComputerException("Missing 'type' element");
        }
        String string = (String)type;
        FilterType filterType = SpecialConverters.sanitizeStringToEnum(FilterType.class, string);
        if (filterType == null) {
            throw new ComputerException("Unknown 'type' value");
        }
        IFilter<?> filter = BaseFilter.fromType(filterType);
        if (!expectedType.isInstance(filter)) {
            throw new ComputerException("Type is not of an expected format");
        }
        Object enabled = map.get("enabled");
        if (enabled instanceof Boolean) {
            Boolean enable = (Boolean)enabled;
            filter.setEnabled(enable);
        }
        if (filter instanceof IItemStackFilter) {
            IItemStackFilter itemFilter = (IItemStackFilter)filter;
            SpecialConverters.decodeItemStackFilter(map, itemFilter);
        } else if (filter instanceof IModIDFilter) {
            IModIDFilter modIDFilter = (IModIDFilter)filter;
            SpecialConverters.decodeModIdFilter(map, modIDFilter);
        } else if (filter instanceof ITagFilter) {
            ITagFilter tagFilter = (ITagFilter)filter;
            SpecialConverters.decodeTagFilter(map, tagFilter);
        }
        if (filter instanceof MinerFilter) {
            MinerFilter minerFilter = (MinerFilter)filter;
            SpecialConverters.decodeMinerFilter(map, minerFilter);
        } else if (filter instanceof SorterFilter) {
            SorterFilter sorterFilter = (SorterFilter)filter;
            SpecialConverters.decodeSorterFilter(map, sorterFilter);
        } else if (filter instanceof QIOFilter) {
            QIOFilter qioFilter = (QIOFilter)filter;
            SpecialConverters.decodeQioFilter(map, qioFilter);
        } else if (filter instanceof OredictionificatorFilter) {
            OredictionificatorFilter oredictionificatorFilter = (OredictionificatorFilter)filter;
            SpecialConverters.decodeOreDictFilter(map, oredictionificatorFilter);
        }
        return (FILTER)((IFilter)expectedType.cast(filter));
    }

    private static void decodeOreDictFilter(@NotNull Map<?, ?> map, OredictionificatorFilter<?, ?, ?> oredictionificatorFilter) throws ComputerException {
        String tag;
        Object rawTag = map.get("target");
        if (!(rawTag instanceof String) || (tag = (String)rawTag).isEmpty()) {
            throw new ComputerException("Missing 'target'");
        }
        ResourceLocation rl = ResourceLocation.m_135820_((String)tag);
        if (rl == null || !TileEntityOredictionificator.isValidTarget(rl)) {
            throw new ComputerException("Invalid 'target'");
        }
        oredictionificatorFilter.setFilter(rl);
        if (oredictionificatorFilter instanceof OredictionificatorItemFilter) {
            OredictionificatorItemFilter itemFilter = (OredictionificatorItemFilter)oredictionificatorFilter;
            Item item = SpecialConverters.tryCreateItem(map.get("selected"));
            if (item != Items.f_41852_) {
                itemFilter.setSelectedOutput(item);
            }
        }
    }

    private static void decodeQioFilter(@NotNull Map<?, ?> map, QIOFilter<?> qioFilter) {
        if (qioFilter instanceof QIOItemStackFilter) {
            QIOItemStackFilter qioItemFilter = (QIOItemStackFilter)qioFilter;
            qioItemFilter.fuzzyMode = SpecialConverters.getBooleanFromRaw(map.get("fuzzy"));
        }
    }

    private static void decodeSorterFilter(@NotNull Map<?, ?> map, SorterFilter<?> sorterFilter) throws ComputerException {
        sorterFilter.allowDefault = SpecialConverters.getBooleanFromRaw(map.get("allowDefault"));
        Object rawColor = map.get("color");
        if (rawColor instanceof String) {
            sorterFilter.color = SpecialConverters.sanitizeStringToEnum(EnumColor.class, (String)rawColor);
        }
        sorterFilter.sizeMode = SpecialConverters.getBooleanFromRaw(map.get("size"));
        sorterFilter.min = SpecialConverters.getIntFromRaw(map.get("min"));
        sorterFilter.max = SpecialConverters.getIntFromRaw(map.get("max"));
        if (sorterFilter.min < 0 || sorterFilter.max < 0 || sorterFilter.min > sorterFilter.max || sorterFilter.max > 64) {
            throw new ComputerException("Invalid or min/max: 0 <= min <= max <= 64");
        }
        if (sorterFilter instanceof SorterItemStackFilter) {
            SorterItemStackFilter sorterItemFilter = (SorterItemStackFilter)sorterFilter;
            sorterItemFilter.fuzzyMode = SpecialConverters.getBooleanFromRaw(map.get("fuzzy"));
        }
    }

    private static void decodeMinerFilter(@NotNull Map<?, ?> map, MinerFilter<?> minerFilter) {
        minerFilter.requiresReplacement = SpecialConverters.getBooleanFromRaw(map.get("requiresReplacement"));
        minerFilter.replaceTarget = SpecialConverters.tryCreateItem(map.get("replaceTarget"));
    }

    private static void decodeTagFilter(@NotNull Map<?, ?> map, ITagFilter<?> tagFilter) throws ComputerException {
        String tag = SpecialConverters.tryGetFilterTag(map.get("tag"));
        if (tag == null) {
            throw new ComputerException("Invalid or missing tag specified for Tag filter");
        }
        tagFilter.setTagName(tag);
    }

    private static void decodeModIdFilter(@NotNull Map<?, ?> map, IModIDFilter<?> modIDFilter) throws ComputerException {
        String modId = SpecialConverters.tryGetFilterModId(map.get("modId"));
        if (modId == null) {
            throw new ComputerException("Invalid or missing modId specified for Mod Id filter");
        }
        modIDFilter.setModID(modId);
    }

    private static void decodeItemStackFilter(@NotNull Map<?, ?> map, IItemStackFilter<?> itemFilter) throws ComputerException {
        ItemStack stack = SpecialConverters.tryCreateFilterItem((String)map.get("item"), (String)map.get("itemNBT"));
        if (stack.m_41619_()) {
            throw new ComputerException("Invalid or missing item specified for ItemStack filter");
        }
        itemFilter.setItemStack(stack);
    }

    static Map<String, Object> wrapStack(ResourceLocation name, String sizeKey, int amount, @Nullable CompoundTag tag) {
        boolean hasTag = tag != null && !tag.m_128456_() && amount > 0;
        HashMap<String, Object> wrapped = new HashMap<String, Object>(hasTag ? 3 : 2);
        wrapped.put("name", name == null ? "unknown" : name.toString());
        wrapped.put(sizeKey, amount);
        if (hasTag) {
            wrapped.put("nbt", SpecialConverters.wrapNBT(tag));
        }
        return wrapped;
    }

    static String wrapNBT(@NotNull CompoundTag nbt) {
        return NbtUtils.m_178063_((CompoundTag)nbt);
    }
}

