/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.interfaces;

import java.util.Collections;
import java.util.List;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.item.interfaces.IDroppableContents;
import mekanism.common.recipe.upgrade.ItemRecipeData;
import mekanism.common.tile.interfaces.ISustainedInventory;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;

public interface IItemSustainedInventory
extends ISustainedInventory,
IDroppableContents {
    @Override
    default public void setSustainedInventory(ListTag nbtTags) {
        throw new UnsupportedOperationException("IItemSustainedInventory needs a stack to work with");
    }

    default public void setSustainedInventory(ListTag nbtTags, ItemStack stack) {
        ItemDataUtils.setListOrRemove(stack, "Items", nbtTags);
    }

    @Override
    default public ListTag getSustainedInventory() {
        throw new UnsupportedOperationException("IItemSustainedInventory needs a stack to work with");
    }

    default public ListTag getSustainedInventory(ItemStack stack) {
        return ItemDataUtils.getList(stack, "Items");
    }

    default public boolean hasSustainedInventory(ItemStack stack) {
        ListTag inventory = this.getSustainedInventory(stack);
        return inventory != null && !inventory.isEmpty();
    }

    @Override
    default public List<IInventorySlot> getDroppedSlots(ItemStack stack) {
        ListTag inventory = this.getSustainedInventory(stack);
        return inventory == null ? Collections.emptyList() : ItemRecipeData.readContents(inventory);
    }
}

