/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client;

import mekanism.common.capabilities.Capabilities;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketRadiationData
implements IMekanismPacket {
    private final RadiationPacketType type;
    private final double radiation;
    private final double maxMagnitude;

    private PacketRadiationData(RadiationPacketType type, double radiation, double maxMagnitude) {
        this.type = type;
        this.radiation = radiation;
        this.maxMagnitude = maxMagnitude;
    }

    public static PacketRadiationData createEnvironmental(RadiationManager.LevelAndMaxMagnitude levelAndMaxMagnitude) {
        return new PacketRadiationData(RadiationPacketType.ENVIRONMENTAL, levelAndMaxMagnitude.level(), levelAndMaxMagnitude.maxMagnitude());
    }

    public static PacketRadiationData createPlayer(double radiation) {
        return new PacketRadiationData(RadiationPacketType.PLAYER, radiation, 0.0);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        LocalPlayer player;
        if (this.type == RadiationPacketType.ENVIRONMENTAL) {
            RadiationManager.get().setClientEnvironmentalRadiation(this.radiation, this.maxMagnitude);
        } else if (this.type == RadiationPacketType.PLAYER && (player = Minecraft.m_91087_().f_91074_) != null) {
            player.getCapability(Capabilities.RADIATION_ENTITY).ifPresent(c -> c.set(this.radiation));
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.type);
        buffer.writeDouble(this.radiation);
        if (this.type.tracksMaxMagnitude) {
            buffer.writeDouble(this.maxMagnitude);
        }
    }

    public static PacketRadiationData decode(FriendlyByteBuf buffer) {
        RadiationPacketType type = (RadiationPacketType)buffer.m_130066_(RadiationPacketType.class);
        return new PacketRadiationData(type, buffer.readDouble(), type.tracksMaxMagnitude ? buffer.readDouble() : 0.0);
    }

    public static enum RadiationPacketType {
        ENVIRONMENTAL(true),
        PLAYER(false);

        private final boolean tracksMaxMagnitude;

        private RadiationPacketType(boolean tracksMaxMagnitude) {
            this.tracksMaxMagnitude = tracksMaxMagnitude;
        }
    }
}

