/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.item.CursedTransporterItemHandler;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityLogisticalTransporterBase
extends TileEntityTransmitter {
    protected TileEntityLogisticalTransporterBase(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.addCapabilityResolver(new TransporterCapabilityResolver());
    }

    protected abstract LogisticalTransporterBase createTransmitter(IBlockProvider var1);

    public LogisticalTransporterBase getTransmitter() {
        return (LogisticalTransporterBase)super.getTransmitter();
    }

    public static void tickClient(Level level, BlockPos pos, BlockState state, TileEntityLogisticalTransporterBase transmitter) {
        transmitter.getTransmitter().onUpdateClient();
    }

    @Override
    public void onUpdateServer() {
        super.onUpdateServer();
        this.getTransmitter().onUpdateServer();
    }

    @Override
    public void blockRemoved() {
        LogisticalTransporterBase transporter;
        super.blockRemoved();
        if (!this.isRemote() && !(transporter = this.getTransmitter()).isUpgrading()) {
            for (TransporterStack stack : transporter.getTransit()) {
                TransporterUtils.drop(transporter, stack);
            }
        }
    }

    @Override
    public void sideChanged(@NotNull Direction side, @NotNull ConnectionType old, @NotNull ConnectionType type) {
        super.sideChanged(side, old, type);
        if (type == ConnectionType.NONE && old != ConnectionType.PUSH || type == ConnectionType.PUSH && old != ConnectionType.NONE) {
            this.invalidateCapability((Capability<?>)ForgeCapabilities.ITEM_HANDLER, side);
            WorldUtils.notifyNeighborOfChange(this.f_58857_, side, this.f_58858_);
        } else if (old == ConnectionType.NONE && type != ConnectionType.PUSH || old == ConnectionType.PUSH && type != ConnectionType.NONE) {
            WorldUtils.notifyNeighborOfChange(this.f_58857_, side, this.f_58858_);
        }
    }

    @NothingNullByDefault
    private class TransporterCapabilityResolver
    implements ICapabilityResolver {
        private static final List<Capability<?>> SUPPORTED_CAPABILITY = Collections.singletonList(ForgeCapabilities.ITEM_HANDLER);
        private final Map<Direction, CursedTransporterItemHandler> cursedHandlers = new EnumMap<Direction, CursedTransporterItemHandler>(Direction.class);
        private final Map<Direction, LazyOptional<IItemHandler>> handlers = new EnumMap<Direction, LazyOptional<IItemHandler>>(Direction.class);

        private TransporterCapabilityResolver() {
        }

        @Override
        public List<Capability<?>> getSupportedCapabilities() {
            return SUPPORTED_CAPABILITY;
        }

        @Override
        public <T> LazyOptional<T> resolve(Capability<T> capability, @Nullable Direction side) {
            if (side == null) {
                return LazyOptional.empty();
            }
            LazyOptional cachedCapability = this.handlers.get(side);
            if (cachedCapability == null || !cachedCapability.isPresent()) {
                LogisticalTransporterBase transporter = TileEntityLogisticalTransporterBase.this.getTransmitter();
                if (transporter.exposesInsertCap(side)) {
                    cachedCapability = LazyOptional.of(() -> this.cursedHandlers.computeIfAbsent(side, s -> new CursedTransporterItemHandler(transporter, TileEntityLogisticalTransporterBase.this.f_58858_.m_121945_(s), () -> TileEntityLogisticalTransporterBase.this.f_58857_ == null ? -1L : TileEntityLogisticalTransporterBase.this.f_58857_.m_46467_())));
                    this.handlers.put(side, (LazyOptional<IItemHandler>)cachedCapability);
                } else {
                    return LazyOptional.empty();
                }
            }
            return cachedCapability.cast();
        }

        @Override
        public void invalidate(Capability<?> capability, @Nullable Direction side) {
            if (side != null) {
                this.invalidate(this.handlers.get(side));
            }
        }

        @Override
        public void invalidateAll() {
            this.handlers.values().forEach(this::invalidate);
        }

        protected void invalidate(@Nullable LazyOptional<?> cachedCapability) {
            if (cachedCapability != null && cachedCapability.isPresent()) {
                cachedCapability.invalidate();
            }
        }
    }
}

