/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tacz.guns.block.TargetBlock;
import com.tacz.guns.block.entity.StatueBlockEntity;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.resource.InternalAssetLoader;
import com.tacz.guns.config.client.RenderConfig;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class StatueRenderer
implements BlockEntityRenderer<StatueBlockEntity> {
    public StatueRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static Optional<BedrockModel> getModel() {
        return InternalAssetLoader.getBedrockModel(InternalAssetLoader.STATUE_MODEL_LOCATION);
    }

    public void render(StatueBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        StatueRenderer.getModel().ifPresent(model -> {
            Level level = blockEntity.m_58904_();
            if (level == null) {
                return;
            }
            poseStack.m_85836_();
            BlockState blockState = blockEntity.m_58900_();
            Direction facing = (Direction)blockState.m_61143_((Property)TargetBlock.FACING);
            poseStack.m_85837_(0.5, 1.5, 0.5);
            poseStack.m_252781_(Axis.f_252392_.m_252977_((float)((facing.m_122416_() + 2) % 4 * 90)));
            poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
            RenderType renderType = RenderType.m_110473_((ResourceLocation)StatueRenderer.getTextureLocation());
            model.render(poseStack, ItemDisplayContext.NONE, renderType, combinedLightIn, combinedOverlayIn);
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_85837_(0.0, -0.875, -1.2);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            double offset = Math.sin((double)Util.m_137550_() / 500.0) * 0.1;
            poseStack.m_85837_(0.0, offset, 0.0);
            ItemStack stack = blockEntity.getGunItem();
            Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_, poseStack, bufferIn, level, 0);
            poseStack.m_85849_();
        });
    }

    public static ResourceLocation getTextureLocation() {
        return InternalAssetLoader.STATUE_TEXTURE_LOCATION;
    }

    public int m_142163_() {
        return (Integer)RenderConfig.TARGET_RENDER_DISTANCE.get();
    }

    public boolean shouldRenderOffScreen(StatueBlockEntity blockEntity) {
        return true;
    }

    public boolean shouldRender(StatueBlockEntity pBlockEntity, Vec3 pCameraPos) {
        return Vec3.m_82512_((Vec3i)pBlockEntity.m_58899_().m_7494_()).m_82509_((Position)pCameraPos, (double)this.m_142163_());
    }
}

