/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.shooter;

import com.tacz.guns.api.event.common.GunFireSelectEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunFireSelect;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;

public class LivingEntityFireSelect {
    private final LivingEntity shooter;
    private final ShooterDataHolder data;

    public LivingEntityFireSelect(LivingEntity shooter, ShooterDataHolder data) {
        this.shooter = shooter;
        this.data = data;
    }

    public void fireSelect() {
        if (this.data.currentGunItem == null) {
            return;
        }
        ItemStack currentGunItem = this.data.currentGunItem.get();
        Item item = currentGunItem.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        if (MinecraftForge.EVENT_BUS.post((Event)new GunFireSelectEvent(this.shooter, currentGunItem, LogicalSide.SERVER))) {
            return;
        }
        NetworkHandler.sendToTrackingEntity(new ServerMessageGunFireSelect(this.shooter.m_19879_(), currentGunItem), (Entity)this.shooter);
        if (iGun instanceof AbstractGunItem) {
            AbstractGunItem logicGun = (AbstractGunItem)iGun;
            logicGun.fireSelect(this.data, currentGunItem);
            AttachmentPropertyManager.postChangeEvent(this.shooter, currentGunItem);
        }
    }
}

