/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.tacz.guns.GunMod;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.resource.PackMeta;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.time.StopWatch;

public class PackConvertor {
    public static final Path FOLDER = Paths.get("config", "tacz", "custom");
    public static final Pattern PACK_INFO_PATTERN = Pattern.compile("^(\\w+)/pack\\.json$");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private static Component pre(Component component) {
        return Component.m_237115_((String)"message.tacz.pre").m_7220_(component);
    }

    private static void msg(CommandSourceStack source, Component component) {
        source.m_243053_(PackConvertor.pre(component));
    }

    public static void convert(CommandSourceStack source) {
        Path resourcePacksPath = FMLPaths.GAMEDIR.get().resolve("tacz");
        File folder = resourcePacksPath.toFile();
        if (!folder.isDirectory()) {
            try {
                Files.createDirectories(folder.toPath(), new FileAttribute[0]);
            }
            catch (Exception e) {
                PackConvertor.msg(source, (Component)Component.m_237115_((String)"message.tacz.converter.init_failed"));
                GunMod.LOGGER.error("Failed to init tacz directory...", (Throwable)e);
                return;
            }
        }
        File[] files = FOLDER.toFile().listFiles();
        int cnt = 0;
        int skip = 0;
        int error = 0;
        if (files != null && files.length > 0) {
            StopWatch watch = StopWatch.createStarted();
            PackConvertor.msg(source, (Component)Component.m_237115_((String)"message.tacz.converter.start"));
            GunMod.LOGGER.info("Start converting legacy packs...");
            for (File file : files) {
                if (file.isFile() && file.getName().endsWith(".zip")) {
                    LegacyPack pack = PackConvertor.fromZipFile(file);
                    if (pack == null) continue;
                    PackConvertor.msg(source, (Component)Component.m_237110_((String)"message.tacz.converter.pack.start", (Object[])new Object[]{file.getName()}));
                    GunMod.LOGGER.info("Attempt to converting legacy pack: {}", (Object)file.getName());
                    try {
                        pack.convert();
                    }
                    catch (FileAlreadyExistsException e) {
                        PackConvertor.msg(source, (Component)Component.m_237115_((String)"message.tacz.converter.pack.exist"));
                        GunMod.LOGGER.warn("Target file already exists: {}", (Object)file.getName());
                        ++skip;
                        continue;
                    }
                    catch (Exception e) {
                        PackConvertor.msg(source, (Component)Component.m_237110_((String)"message.tacz.converter.pack.failed", (Object[])new Object[]{file.getName()}));
                        GunMod.LOGGER.error("Failed to convert legacy pack: {}", (Object)file.getName(), (Object)e);
                        ++error;
                        continue;
                    }
                    ++cnt;
                    PackConvertor.msg(source, (Component)Component.m_237110_((String)"message.tacz.converter.pack.finish", (Object[])new Object[]{file.getName()}));
                    GunMod.LOGGER.info("Legacy pack converted: {}", (Object)file.getName());
                    continue;
                }
                PackConvertor.msg(source, (Component)Component.m_237110_((String)"message.tacz.converter.pack.folder", (Object[])new Object[]{file.getName()}));
                GunMod.LOGGER.warn("Skip folder: {}", (Object)file.getName());
                ++skip;
            }
            watch.stop();
            double time = (double)watch.getTime(TimeUnit.MICROSECONDS) / 1000.0;
            PackConvertor.msg(source, (Component)Component.m_237110_((String)"message.tacz.converter.finish", (Object[])new Object[]{time, cnt, skip, error}));
            GunMod.LOGGER.info("Convert finished! Total time: {} ms. Success : {}. Skipped {}. Failed: {}. Restart the game to load new packs!", (Object)time, (Object)cnt, (Object)skip, (Object)error);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LegacyPack fromZipFile(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> iteration = zipFile.entries();
            while (iteration.hasMoreElements()) {
                String path = iteration.nextElement().getName();
                Matcher matcher = PACK_INFO_PATTERN.matcher(path);
                if (!matcher.find()) continue;
                String namespace = matcher.group(1);
                ZipEntry entry = zipFile.getEntry(path);
                try {
                    InputStream stream;
                    block16: {
                        stream = zipFile.getInputStream(entry);
                        PackInfo info = (PackInfo)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), PackInfo.class);
                        if (info == null) break block16;
                        LegacyPack legacyPack = new LegacyPack(file, namespace, info);
                        if (stream == null) return legacyPack;
                        {
                            catch (Throwable throwable) {
                                if (stream == null) throw throwable;
                                try {
                                    stream.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        stream.close();
                        return legacyPack;
                    }
                    if (stream == null) continue;
                    stream.close();
                }
                catch (JsonIOException | JsonSyntaxException | IOException exception) {
                    GunMod.LOGGER.warn(exception.getMessage());
                }
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public record LegacyPack(File file, String namespace, PackInfo info) {
        private static final Pattern DISPLAY_PATTERN = Pattern.compile("^(\\w+)/(\\w+)/display/([\\w/.]+)$");
        private static final Pattern INDEX_PATTERN = Pattern.compile("^(\\w+)/(\\w+)/index/([\\w/.]+)$");
        private static final Pattern DATA_PATTERN = Pattern.compile("^(\\w+)/(\\w+)/data/([\\w/.]+)$");
        private static final Pattern MODELS_PATTERN = Pattern.compile("^(\\w+)/models/([\\w/.]+)$");
        private static final Pattern LANG_PATTERN = Pattern.compile("^(\\w+)/lang/([\\w/.]+)$");
        private static final Pattern ANIMATION_PATTERN = Pattern.compile("^(\\w+)/animations/([\\w/.]+)$");
        private static final Pattern TEXTURE_PATTERN = Pattern.compile("^(\\w+)/textures/([\\w/.]+)$");
        private static final Pattern SOUND_PATTERN = Pattern.compile("^(\\w+)/sounds/([\\w/.]+)$");
        private static final Pattern PLAYER_ANIMATOR_PATTERN = Pattern.compile("^(\\w+)/player_animator/([\\w/.]+)$");
        private static final Pattern TAGS_PATTERN = Pattern.compile("^(\\w+)/tags/([\\w/.]+)$");
        private static final Pattern RECIPE_PATTERN = Pattern.compile("^(\\w+)/recipes/([\\w/.]+)$");
        private static final Pattern PACK_INFO = Pattern.compile("^(\\w+)/pack\\.json$");

        private boolean parsePackInfo(ZipOutputStream newZip, ZipEntry entry, ZipFile oldPack) throws IOException {
            Matcher matcher = PACK_INFO.matcher(entry.getName());
            if (matcher.find()) {
                String namespace = matcher.group(1);
                String newPath = "assets/" + namespace + "/gunpack_info.json";
                this.writeEntry(newZip, entry, oldPack, newPath);
                return true;
            }
            return false;
        }

        private boolean parseRecipe(ZipOutputStream newZip, ZipEntry entry, ZipFile oldPack) throws IOException {
            Matcher matcher = RECIPE_PATTERN.matcher(entry.getName());
            if (matcher.find()) {
                String namespace = matcher.group(1);
                String path = matcher.group(2);
                String newPath = "data/" + namespace + "/recipes/" + path;
                try (InputStream stream = oldPack.getInputStream(entry);){
                    JsonObject object = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), JsonObject.class);
                    if (object != null) {
                        object.addProperty("type", "tacz:gun_smith_table_crafting");
                        newZip.putNextEntry(new ZipEntry(newPath));
                        newZip.write(GSON.toJson((JsonElement)object).getBytes());
                        newZip.closeEntry();
                    }
                }
                catch (JsonParseException e) {
                    GunMod.LOGGER.warn("Failed to parse recipe to new style: {}", (Object)entry.getName());
                }
                return true;
            }
            return false;
        }

        private boolean parseTags(ZipOutputStream newZip, ZipEntry entry, ZipFile oldPack) throws IOException {
            Matcher matcher = TAGS_PATTERN.matcher(entry.getName());
            if (matcher.find()) {
                String namespace = matcher.group(1);
                String path = matcher.group(2);
                String newPath = "data/" + namespace + "/tacz_tags/" + path;
                this.writeEntry(newZip, entry, oldPack, newPath);
                return true;
            }
            return false;
        }

        private boolean parsePlayerAnimator(ZipOutputStream newZip, ZipEntry entry, ZipFile oldPack) throws IOException {
            Matcher matcher = PLAYER_ANIMATOR_PATTERN.matcher(entry.getName());
            if (matcher.find()) {
                String namespace = matcher.group(1);
                String path = matcher.group(2);
                String newPath = "assets/" + namespace + "/player_animator/" + path;
                this.writeEntry(newZip, entry, oldPack, newPath);
                return true;
            }
            return false;
        }

        private boolean parseSound(ZipOutputStream newZip, ZipEntry entry, ZipFile oldPack) throws IOException {
            Matcher matcher = SOUND_PATTERN.matcher(entry.getName());
            if (matcher.find()) {
                String namespace = matcher.group(1);
                String path = matcher.group(2);
                String newPath = "assets/" + namespace + "/tacz_sounds/" + path;
                this.writeEntry(newZip, entry, oldPack, newPath);
                return true;
            }
            return false;
        }

        private boolean parseTexture(ZipOutputStream newZip, ZipEntry entry, ZipFile oldPack) throws IOException {
            Matcher matcher = TEXTURE_PATTERN.matcher(entry.getName());
            if (matcher.find()) {
                String namespace = matcher.group(1);
                String path = matcher.group(2);
                String newPath = "assets/" + namespace + "/textures/" + path;
                this.writeEntry(newZip, entry, oldPack, newPath);
                return true;
            }
            return false;
        }

        private boolean parseAnimation(ZipOutputStream newZip, ZipEntry entry, ZipFile oldPack) throws IOException {
            Matcher matcher = ANIMATION_PATTERN.matcher(entry.getName());
            if (matcher.find()) {
                String namespace = matcher.group(1);
                String path = matcher.group(2);
                String newPath = "assets/" + namespace + "/animations/" + path;
                this.writeEntry(newZip, entry, oldPack, newPath);
                return true;
            }
            return false;
        }

        private boolean parseLang(ZipOutputStream newZip, ZipEntry entry, ZipFile oldPack) throws IOException {
            Matcher matcher = LANG_PATTERN.matcher(entry.getName());
            if (matcher.find()) {
                String namespace = matcher.group(1);
                String path = matcher.group(2);
                String newPath = "assets/" + namespace + "/lang/" + path;
                this.writeEntry(newZip, entry, oldPack, newPath);
                return true;
            }
            return false;
        }

        private boolean parseModels(ZipOutputStream newZip, ZipEntry entry, ZipFile oldPack) throws IOException {
            Matcher matcher = MODELS_PATTERN.matcher(entry.getName());
            if (matcher.find()) {
                String namespace = matcher.group(1);
                String path = matcher.group(2);
                String newPath = "assets/" + namespace + "/geo_models/" + path;
                this.writeEntry(newZip, entry, oldPack, newPath);
                return true;
            }
            return false;
        }

        private boolean parseDisplay(ZipOutputStream newZip, ZipEntry entry, ZipFile oldPack) throws IOException {
            Matcher matcher = DISPLAY_PATTERN.matcher(entry.getName());
            if (matcher.find()) {
                String namespace = matcher.group(1);
                String type = matcher.group(2);
                String path = matcher.group(3);
                String newPath = "assets/" + namespace + "/display/" + type + "/" + path;
                this.writeEntry(newZip, entry, oldPack, newPath);
                return true;
            }
            return false;
        }

        private boolean parseIndex(ZipOutputStream newZip, ZipEntry entry, ZipFile oldPack) throws IOException {
            Matcher matcher = INDEX_PATTERN.matcher(entry.getName());
            if (matcher.find()) {
                String namespace = matcher.group(1);
                String type = matcher.group(2);
                String path = matcher.group(3);
                String newPath = "data/" + namespace + "/index/" + type + "/" + path;
                this.writeEntry(newZip, entry, oldPack, newPath);
                return true;
            }
            return false;
        }

        private boolean parseData(ZipOutputStream newZip, ZipEntry entry, ZipFile oldPack) throws IOException {
            Matcher matcher = DATA_PATTERN.matcher(entry.getName());
            if (matcher.find()) {
                String namespace = matcher.group(1);
                String type = matcher.group(2);
                String path = matcher.group(3);
                String newPath = "data/" + namespace + "/data/" + type + "/" + path;
                this.writeEntry(newZip, entry, oldPack, newPath);
                return true;
            }
            return false;
        }

        private void writeEntry(ZipOutputStream newZip, ZipEntry entry, ZipFile oldPack, String newPath) throws IOException {
            newZip.putNextEntry(new ZipEntry(newPath));
            try (InputStream is = oldPack.getInputStream(entry);){
                int len;
                byte[] buffer = new byte[1024];
                while ((len = is.read(buffer)) > 0) {
                    newZip.write(buffer, 0, len);
                }
            }
            newZip.closeEntry();
        }

        private void addMeta(ZipOutputStream newZip) throws IOException {
            ZipEntry entry = new ZipEntry("gunpack.meta.json");
            newZip.putNextEntry(entry);
            PackMeta meta = new PackMeta(this.namespace, null);
            newZip.write(GSON.toJson((Object)meta).getBytes());
            newZip.closeEntry();
        }

        public void convert() throws FileAlreadyExistsException {
            Path newPath = FMLPaths.GAMEDIR.get().resolve("tacz");
            String newName = this.file.getName().replace(".zip", "") + "_converted.zip";
            File newFile = new File(newPath.toFile(), newName);
            if (newFile.isFile() && newFile.exists()) {
                throw new FileAlreadyExistsException("File already exists: " + newFile.getName());
            }
            try (ZipFile oldPack = new ZipFile(this.file);
                 FileOutputStream outputStream = new FileOutputStream(newFile);
                 ZipOutputStream newZip = new ZipOutputStream(outputStream);){
                this.addMeta(newZip);
                Enumeration<? extends ZipEntry> iteration = oldPack.entries();
                while (iteration.hasMoreElements()) {
                    ZipEntry entry = iteration.nextElement();
                    if (!this.parseDisplay(newZip, entry, oldPack) && !this.parseIndex(newZip, entry, oldPack) && !this.parseData(newZip, entry, oldPack) && !this.parseModels(newZip, entry, oldPack) && !this.parseLang(newZip, entry, oldPack) && !this.parseAnimation(newZip, entry, oldPack) && !this.parseTexture(newZip, entry, oldPack) && !this.parseSound(newZip, entry, oldPack) && !this.parsePlayerAnimator(newZip, entry, oldPack) && !this.parseTags(newZip, entry, oldPack) && !this.parseRecipe(newZip, entry, oldPack) && !this.parsePackInfo(newZip, entry, oldPack)) continue;
                }
            }
            catch (IOException e) {
                GunMod.LOGGER.warn("Failed to convert pack: {}", (Object)this.file.getName());
            }
        }
    }
}

