/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.client.resource.pojo.display.LaserConfig;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class LaserColorUtil {
    public static int getLaserColor(ItemStack stack, @NotNull LaserConfig defaultConfig) {
        if (stack == null) {
            return defaultConfig.getDefaultColor();
        }
        Item item = stack.m_41720_();
        if (item instanceof IAttachment) {
            IAttachment iAttachment = (IAttachment)item;
            if (iAttachment.hasCustomLaserColor(stack)) {
                return iAttachment.getLaserColor(stack);
            }
            return defaultConfig.getDefaultColor();
        }
        item = stack.m_41720_();
        if (item instanceof IGun) {
            IGun gun = (IGun)item;
            if (gun.hasCustomLaserColor(stack)) {
                return gun.getLaserColor(stack);
            }
            return defaultConfig.getDefaultColor();
        }
        return defaultConfig.getDefaultColor();
    }

    public static int getLaserColor(ItemStack stack) {
        if (stack == null) {
            return 0xFF0000;
        }
        Item item = stack.m_41720_();
        if (item instanceof IAttachment) {
            IAttachment iAttachment = (IAttachment)item;
            if (iAttachment.hasCustomLaserColor(stack)) {
                return iAttachment.getLaserColor(stack);
            }
            return TimelessAPI.getClientAttachmentIndex(iAttachment.getAttachmentId(stack)).map(ClientAttachmentIndex::getLaserConfig).map(LaserConfig::getDefaultColor).orElse(0xFF0000);
        }
        item = stack.m_41720_();
        if (item instanceof IGun) {
            IGun gun = (IGun)item;
            if (gun.hasCustomLaserColor(stack)) {
                return gun.getLaserColor(stack);
            }
            return TimelessAPI.getGunDisplay(stack).map(GunDisplayInstance::getLaserConfig).map(LaserConfig::getDefaultColor).orElse(0xFF0000);
        }
        return 0xFF0000;
    }
}

